# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def tranquil_serpent(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history) + 1
    opp_coop_rate = opp_history.count("C") / len(opp_history)
    
    # Early game: build trust
    if current_round <= 3:
        return "C"
    
    # Mid-game: dynamic response
    if 4 <= current_round <= 7:
        if opp_coop_rate >= 0.7:
            return "C"
        elif opp_coop_rate < 0.3:
            return "D"
        else:
            if random.random() < 0.05:
                return "D"
            return "C"
    
    # Late game: exploit or reciprocate
    if current_round >= 8:
        if opp_coop_rate >= 0.6:
            return "C"
        else:
            if current_round >= 9 or (current_round == 10 and "D" in opp_history[-3:]):
                return "D"
            return "C"
    
    # Fallback: defect if something unexpected happens
    return "D"